<?php

// خواندن اطلاعات از فایل PHP
include_once(__DIR__ . '/baseInfo.php');

$botToken = $botToken ?? '';
$chatID = 7679087477 ?? '';
$dbUser = $dbUserName ?? '';
$dbPass = $dbPassword ?? '';
$dbName = $dbName ?? '';

// بررسی صحت اطلاعات
if (!$botToken || !$chatID || !$dbUser || !$dbPass || !$dbName) {
    die("اطلاعات ناقص است.");
}

// اتصال به دیتابیس
$conn = new mysqli("localhost", $dbUser, $dbPass, $dbName);
if ($conn->connect_error) {
    die("خطا در اتصال: " . $conn->connect_error);
}

$conn->set_charset("utf8");

// ساخت فایل بکاپ
$backupDir = __DIR__ . '/../db_backup';
if (!file_exists($backupDir)) mkdir($backupDir, 0755, true);

$backupFile = $backupDir . '/nbb_' . date('Y-m-d_H-i-s') . '.sql';
$fp = fopen($backupFile, 'w');

$tables = [];
$res = $conn->query("SHOW TABLES");
while ($row = $res->fetch_array()) $tables[] = $row[0];

foreach ($tables as $table) {
    // ساختار جدول
    $res = $conn->query("SHOW CREATE TABLE `$table`");
    $row = $res->fetch_assoc();
    fwrite($fp, "--\n-- ساختار برای جدول `$table`\n--\n\n");
    fwrite($fp, $row['Create Table'] . ";\n\n");

    // اطلاعات جدول
    $res = $conn->query("SELECT * FROM `$table`");
    if ($res->num_rows > 0) {
        fwrite($fp, "--\n-- داده‌ها برای جدول `$table`\n--\n\n");
        while ($row = $res->fetch_assoc()) {
            $values = array_map(function($v) use ($conn) {
                return isset($v) ? "'" . $conn->real_escape_string($v) . "'" : "NULL";
            }, $row);
            fwrite($fp, "INSERT INTO `$table` VALUES (" . implode(", ", $values) . ");\n");
        }
        fwrite($fp, "\n");
    }
}

fclose($fp);

// ارسال به تلگرام
$sendUrl = "https://api.telegram.org/bot$botToken/sendDocument";
$postFields = [
    'chat_id' => $chatID,
    'document' => new CURLFile($backupFile)
];

$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => $sendUrl,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => $postFields
]);

$response = curl_exec($ch);
$error = curl_error($ch);
$code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// حذف فایل
unlink($backupFile);

// نتیجه
if ($code == 200) {
    echo "✅ بکاپ با موفقیت گرفته و ارسال شد.";
} else {
    echo "❌ خطا در ارسال تلگرام: $error\nکد: $code\nپاسخ: $response";
}
